/*
 * Real-time simulation of the OU Houvercraft.
 * 
 * This is intended as a drop-in "replacement" for the physical system.
 * 
 * Author: Andrew H. Fagg   Symbiotic Computing Laboratory 2020-04-15
 * 
 */

#ifndef HOUVERCRAFT_H
#define HOUVERCRAFT_H
//#define _USE_MATH_DEFINES
 
//#include <cmath>
#include <math.h>
#include "Map.h"

#define DEG2RAD(x) ((x)*M_PI/180.0)
#define RAD2DEG(x) ((x)*180.0/M_PI)


typedef enum {
   SHARP_0 = 0,
   SHARP_1 = 1
}SharpSensor;


class Houvercraft {
  public:
  static const int N_DIR_SENSOR = 2;
    static const int N_FANS = 3;
    static const int N_DIM = 3;
    static const int DIM_X = 0;
    static const int DIM_Y = 1;
    static const int DIM_THETA = 2;
    static const int FAN_THRESHOLD = 50;
    static constexpr float MASS = 2.0f;
    static constexpr float R_INERTIA = 1.0f;
    static constexpr float RADIUS = 0.15f;
    static constexpr float DT = 0.005f;
    static constexpr float RAND_FORCE = 1.0;
    static constexpr float RAND_TORQUE = 0.8;
    static constexpr float RAND_YAW = 2.0;
    static constexpr float RAND_GZ = 20.0;
    static constexpr float RAND_DISTANCE = 0.05;
    static constexpr float RAND_CART = 0.001;
    static constexpr float RAND_ROT = 0.5;
    
    Houvercraft(float sensor0_dir, float sensor1_dir);
    void step();
    void print_state();
    void reset();
    void set_lateral_fan_magnitudes(float magnitudes[N_FANS]);
    float imu_gz();
    float imu_yaw();
    void fan_write(int duty);
    void compute_chassis_motion(float cartesian_change[N_DIM]);
    void set_stochastic(int stochastic);
    void set_debug(int debug);
    float get_rand();
    void print_map();
    void set_task(int t);
    float read_distance(SharpSensor side);
    void set_position(float x, float y, float theta);
        
  private:
    float distance_sensor_directions[N_DIR_SENSOR];
    float position[N_DIM];        // Global position
    float velocity[N_DIM];        // Global velocity
    float fan_magnitudes[N_FANS];
    float accumulated_position[N_DIM];
    int central_fan;            // Central fan magnitude
    int stochastic;
    int debug_flag;
    int collisions;
    Map map;
    int task;
};



#endif
