/*
 * Model of the environment map
 * 
 * NOTE: there is no error checking for the bounds of the map.
 * 
 * Author: Andrew H. Fagg   Symbiotic Computing Laboratory 2020-04-15
 * 
 */
 
#include "Segment.h"
#include <vector>

class Map {
  public:
    static const int MAP_ROWS = 16;
    static const int MAP_COLS = 52;
    static constexpr float M2RPIXEL = 5.0;
    static constexpr float M2CPIXEL = 12;
    
    Map();
    std::vector<Segment*> segments;
    SegmentType collision(float X[2], float radius);
    void print(float X[2], char c);
    float intersection_distance(float X[2], float theta);
    
    char map[MAP_ROWS][MAP_COLS+1];
    
  private:
    void populate_map();
};
