/*
 * Model of a single line segment.
 * 
 * Line segments are either vertical or horizontal.  
 *
 * 
 * 
 * Author: Andrew H. Fagg   Symbiotic Computing Laboratory 2020-04-15
 * 
 */
 
 #include "math.h"

typedef enum
{
  NONE=0,
  HORIZONTAL=1,
  VERTICAL=2  
} SegmentType;

class Segment {
  public:
    static constexpr float MAX_DISTANCE = 0.8f;
    
    SegmentType type;
    float x;
    float y[2];
    Segment(SegmentType type, float x, float y0, float y1);
    SegmentType collision(float X[2], float radius);
    float intersection_distance(float X[2], float theta);
};
